/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.gui.screens;

import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.components.HorizontalStack;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.Text;
import de.ambertation.wunderlib.ui.layout.components.VerticalStack;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.HelloClient;
import org.betterx.bclib.client.gui.screens.BCLibLayoutScreen;
import org.betterx.bclib.util.Triple;
import org.betterx.worlds.together.util.ModUtil;
import org.betterx.worlds.together.util.PathUtil;

@Environment(value=EnvType.CLIENT)
public class ModListScreen
extends BCLibLayoutScreen {
    private final List<ModUtil.ModInfo> mods;
    private final HelloClient.IServerModMap serverInfo;
    private final Component description;
    private final Component buttonTitle;

    private static List<ModUtil.ModInfo> extractModList(Map<String, ModUtil.ModInfo> mods) {
        LinkedList<ModUtil.ModInfo> list = new LinkedList<ModUtil.ModInfo>();
        ModUtil.getMods().forEach((id, info) -> list.add((ModUtil.ModInfo)info));
        return list;
    }

    public ModListScreen(Screen parent, Component title, Component description, Map<String, ModUtil.ModInfo> mods, HelloClient.IServerModMap serverInfo) {
        this(parent, title, description, CommonComponents.f_130660_, mods, serverInfo);
    }

    public ModListScreen(Screen parent, Component title, Component description, List<ModUtil.ModInfo> mods, HelloClient.IServerModMap serverInfo) {
        this(parent, title, description, CommonComponents.f_130660_, mods, serverInfo);
    }

    public ModListScreen(Screen parent, Component title, Component description, Component button, Map<String, ModUtil.ModInfo> mods, HelloClient.IServerModMap serverInfo) {
        this(parent, title, description, button, ModListScreen.extractModList(mods), serverInfo);
    }

    public ModListScreen(Screen parent, Component title, Component description, Component button, List<ModUtil.ModInfo> mods, HelloClient.IServerModMap serverInfo) {
        super(parent, title);
        this.mods = mods;
        this.serverInfo = serverInfo;
        this.description = description;
        this.buttonTitle = button;
    }

    public static List<String> localMissing(HelloClient.IServerModMap serverInfo) {
        return serverInfo.keySet().stream().filter(modid -> !ModUtil.getMods().keySet().stream().filter(mod -> mod.equals(modid)).findFirst().isPresent()).collect(Collectors.toList());
    }

    public static List<String> serverMissing(HelloClient.IServerModMap serverInfo) {
        return ModUtil.getMods().entrySet().stream().filter(entry -> ((ModUtil.ModInfo)entry.getValue()).metadata.getEnvironment() != ModEnvironment.CLIENT).map(entry -> (String)entry.getKey()).filter(modid -> !serverInfo.keySet().stream().filter(mod -> mod.equals(modid)).findFirst().isPresent()).collect(Collectors.toList());
    }

    public static void addModDesc(VerticalStack grid, List<ModUtil.ModInfo> mods, HelloClient.IServerModMap serverInfo) {
        int STATE_OK = 6;
        int STATE_SERVER_MISSING_CLIENT_MOD = 5;
        int STATE_MISSING_NOT_OFFERED = 4;
        int STATE_VERSION_CLIENT_ONLY = 7;
        int STATE_VERSION_NOT_OFFERED = 3;
        int STATE_VERSION = 2;
        boolean STATE_SERVER_MISSING = true;
        boolean STATE_MISSING = false;
        LinkedList items = new LinkedList();
        if (serverInfo != null) {
            serverInfo.keySet().stream().filter(modid -> !mods.stream().filter(mod -> mod.metadata.getId().equals(modid)).findFirst().isPresent()).forEach(modid -> {
                HelloClient.OfferedModInfo nfo = (HelloClient.OfferedModInfo)serverInfo.get(modid);
                Object stateString = nfo.version();
                if (nfo.size() > 0) {
                    stateString = "Version: " + (String)stateString + ", Size: " + PathUtil.humanReadableFileSize(nfo.size());
                }
                if (nfo.canDownload()) {
                    stateString = (String)stateString + ", offered by server";
                }
                items.add(new Triple<String, Integer, Object>((String)modid, nfo.canDownload() ? 0 : 4, stateString));
            });
        }
        mods.forEach(mod -> {
            String serverVersion = null;
            int serverSize = 0;
            int state = 6;
            if (serverInfo != null) {
                String modID = mod.metadata.getId();
                HelloClient.OfferedModInfo data = (HelloClient.OfferedModInfo)serverInfo.get(modID);
                if (data != null) {
                    String modVer = data.version();
                    int size = data.size();
                    if (!modVer.equals(mod.getVersion())) {
                        state = mod.metadata.getEnvironment() == ModEnvironment.CLIENT ? 7 : (data.canDownload() ? 2 : 3);
                        serverVersion = modVer;
                        serverSize = size;
                    }
                } else {
                    state = mod.metadata.getEnvironment() == ModEnvironment.CLIENT ? 5 : 1;
                }
            }
            Object stateString = mod.metadata.getVersion().toString();
            if (serverVersion != null) {
                stateString = "Client: " + (String)stateString;
                stateString = (String)stateString + ", Server: " + serverVersion;
                if (serverSize > 0) {
                    stateString = (String)stateString + ", Size: " + PathUtil.humanReadableFileSize(serverSize);
                }
            }
            if (mod.metadata.getEnvironment() == ModEnvironment.CLIENT) {
                stateString = (String)stateString + ", client-only";
            } else if (mod.metadata.getEnvironment() == ModEnvironment.SERVER) {
                stateString = (String)stateString + ", server-only";
            }
            items.add(new Triple<String, Integer, Object>(mod.metadata.getName(), state, stateString));
        });
        items.stream().filter(t -> (Integer)t.second != 1).sorted(Comparator.comparing(a -> a.second + ((String)a.first).toLowerCase(Locale.ROOT))).forEach(t -> {
            String typeText;
            String name = (String)t.first;
            int state = (Integer)t.second;
            String stateString = (String)t.third;
            int color = ColorHelper.RED;
            if (state == 2 || state == 3 || state == 7) {
                typeText = "[VERSION]";
                if (state == 3) {
                    color = ColorHelper.YELLOW;
                } else if (state == 7) {
                    color = ColorHelper.DARK_GREEN;
                }
            } else if (state == 0 || state == 4) {
                typeText = "[MISSING]";
                if (state == 4) {
                    color = ColorHelper.YELLOW;
                }
            } else if (state == 1 || state == 5) {
                if (state == 5) {
                    color = ColorHelper.AQUA;
                    typeText = "[OK]";
                } else {
                    typeText = "[NOT ON SERVER]";
                }
            } else {
                color = ColorHelper.DARK_GREEN;
                typeText = "[OK]";
            }
            MutableComponent dash = Component.m_237113_((String)"-");
            MutableComponent typeTextComponent = Component.m_237113_((String)typeText);
            HorizontalStack row = grid.addRow();
            Text dashText = row.addText(ModListScreen.fit(), ModListScreen.fit(), (Component)dash);
            row.addSpacer(4);
            row.addText(ModListScreen.fit(), ModListScreen.fit(), (Component)Component.m_237113_((String)name));
            row.addSpacer(4);
            row.addText(ModListScreen.fit(), ModListScreen.fit(), (Component)typeTextComponent).setColor(color);
            if (!stateString.isEmpty()) {
                row = grid.addRow();
                row.addSpacer(4 + dashText.getContentWidth());
                row.addText(ModListScreen.fit(), ModListScreen.fit(), (Component)Component.m_237113_((String)stateString)).setColor(ColorHelper.GRAY);
            }
            grid.addSpacer(4);
        });
    }

    protected LayoutComponent<?, ?> initContent() {
        VerticalStack grid = new VerticalStack(ModListScreen.fill(), ModListScreen.fill());
        if (this.description != null) {
            grid.addSpacer(4);
            grid.addMultilineText(ModListScreen.fill(), ModListScreen.fit(), this.description).centerHorizontal();
            grid.addSpacer(8);
        }
        HorizontalStack row = new HorizontalStack(ModListScreen.fill(), ModListScreen.fit());
        row.addSpacer(10);
        VerticalStack col = row.addColumn(ModListScreen.fixed((int)200), ModListScreen.fit());
        ModListScreen.addModDesc(col, this.mods, this.serverInfo);
        grid.addScrollable((LayoutComponent)row);
        grid.addSpacer(8);
        grid.addButton(ModListScreen.fit(), ModListScreen.fit(), this.buttonTitle).onPress(n -> this.m_7379_()).centerHorizontal();
        return grid;
    }
}

